create or replace function tbicds.GetEventDays(pi_vPatientID in varchar2, pi_nEvent1 in number, pi_nEvent2 in number)
   return number 
AUTHID CURRENT_USER
is
   v_vSql                               varchar2(4000);
   v_nResult                            number := null;
   v_dEvent1                            date := null;
   v_dEvent2                            date := null;
begin
  
  --get event date 1
   begin
      v_vSql := 'select t.status_date '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and t.event_id = :P1 '
                || 'and t.status = 1';
      execute immediate v_vSql into v_dEvent1 using pi_vPatientID, pi_nEvent1;
   exception
     when others then
        v_dEvent1 := null;
   end;
  
    --get event date 2
   begin
      v_vSql := 'select t.status_date '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and t.event_id = :P1 '
                || 'and t.status = 1';
      execute immediate v_vSql into v_dEvent2 using pi_vPatientID, pi_nEvent2;
   exception
     when others then
        v_dEvent2 := null;
   end;

   if (v_dEvent2 is not null) and (v_dEvent1 is not null) then
      v_nResult := ROUND(Abs(to_date(trunc(v_dEvent2)) - to_date(trunc(v_dEvent1))), 1);
   end if;
  
   return v_nResult;
end;
/

